class AdvancedUserRecipe1289709253(BasicNewsRecipe):
    title          = u'Sports Illustrated'
    oldest_article = 7
    max_articles_per_feed = 100
    use_embedded_content  = False
    no_stylesheets = True

    remove_javascript     = True
    extra_css = '''
        h1{font-family:Georgia,serif; font-weight:bold;font-size:large;}
        h2{font-family:Georgia,serif; font-weight:normal;font-size:small;}
        p{font-family:Georgia,serif;font-size:small;}
        body{font-family:Georgia,serif;font-size:small;}
        '''

    
    remove_tags_before = dict(id='')
    remove_attributes = ['style', 'font','script']
    remove_tags = [dict(name='div', attrs={'class':['cnnInlineRight','cnnFooterBox','cnnSearchFooter','siv_topper','siv_mainNavCont','siv_searchHeadBox','date','siv_textSize','siv_moreClick','byline','cnnBanner','cnnTopnav','cnnBotnav','cnnRightMoreBox','cnnFooterBox','cnnTimeStamp','cnnShareRow','cnnPersonalize','cnnInlineRight','cnnLeft','possibly-related','post-bottom','comment-wrap','sidebar test','addthis_toolbox_horz','wwwfullmodule','wwwMod','byLine']}),
                   dict(name='div', attrs={'id':['cnnSubBanner','cnnStoryHeader','cnnSCFontButtons','cnnStoryPagination','cnnStoryFooter','cnnSideColumn','cnnViewerAd','cnnSCFontButtons','cnnTimeStamp','authorbio','footer','hdr','comments','cmtForm','rghtRail','ftr','cnngNavbar','cnngBoxscore','nfl-division-news','lftRail','quigo','hatContainer']}),
                   dict(name='p', attrs={'class':['filetag','postTime']}),
                   dict(name='div', attrs={'align':'center'}),
                   dict(name='ul', attrs={'class':['postCmmnts','wrtr']}),
	dict(name='td', attrs={'class':['cnnCol1']}),
                   dict(name='img'),]

    feeds          = [(u'Top Stories', u'http://rss.cnn.com/rss/si_topstories.rss'), 
                          (u'Most Popular', u'http://rss.cnn.com/rss/si_mostpopular.rss'), 
                          (u'NFL', u'http://rss.cnn.com/rss/si_nfl.rss'), 
                          (u'MMA', u'http://rss.cnn.com/rss/si_mma.rss'), 
                          (u'Writers', u'http://rss.cnn.com/rss/si_writers.rss')]
						  
    def preprocess_html(self, soup):
        for alink in soup.findAll('a'):
            if alink.string is not None:
               tstr = alink.string
               alink.replaceWith(tstr)
        return soup
